/********************************************************

   LISTSIMP
   ========

   Rotinas de manipulacao de LISTAS ENCADEADAS SIMPLES:
   - Estruturas de dados com alocacao dinamica
   - Insere no final da lista, no inicio da lista, ou ordenadamente
   - Remocao do inicio da lista, do final da lista, ou elemento especifico

   Aplicacao tipica:
   - Lista de dinamica de elementos de tamanho variavel

   Por: Fernando Osorio
   Data da ultima atualizacao: Out. 2013

*********************************************************/

/* Incluir: stdio.h */

#define FALSO      0
#define VERDADEIRO 1

#define OK         1
#define ERRO       0

typedef int Tipo_Dado;

typedef struct bloco {
                        Tipo_Dado      Dado;
                        struct bloco    *Proximo;
                     }  Nodo;

/***

 => Rotinas de Manipulacao de LISTAS SIMPLES ENCADEADAS
    Alocacao dinamica

***

void inicializa_lista      (Nodo **N);
int insere_inicio_lista    (Nodo **N, Tipo_Dado Dado);
int insere_fim_lista       (Nodo **N, Tipo_Dado Dado);

Possibilidades Adicionais...

int insere_ordenando_lista (Nodo **N, Tipo_Dado Dado);
int remove_inicio_lista    (Nodo **N, Tipo_Dado *Dado);
int remove_fim_lista       (Nodo **N, Tipo_Dado *Dado);
int remove_elemento_lista  (Nodo **N, Tipo_Dado Dado);
int quantidade_lista       (Nodo **N);
void exibe_lista           (Nodo **N);
int pesquisa_lista         (Nodo **N, Tipo_Dado Dado);
int percorre_lista         (Nodo **N, Tipo_Dado *Dado);
void apaga_lista           (Nodo **N);

***/

void inicializa_lista (N)
Nodo **N;
{
  *N = NULL;
}

int insere_inicio_lista (N, Dado)
Nodo **N;
Tipo_Dado Dado;
{
   Nodo   *novo;

   novo = (Nodo *) calloc ( 1, sizeof (Nodo) );
   if  ( novo == NULL )
         return (ERRO);       /* Nao conseguiu alocar espao na memria */
   novo -> Dado = Dado;
   novo -> Proximo = *N;
   *N = novo;
   return (OK);
}

int insere_fim_lista (N, Dado)
Nodo **N;
Tipo_Dado Dado;
{
  Nodo  *aux,  *novo;

  novo = (Nodo *) calloc ( 1, sizeof (Nodo) );
  if  ( novo == NULL )
        return(ERRO);

  novo -> Dado = Dado;
  novo -> Proximo = NULL;

  if ( *N == NULL )
       *N = novo;
  else {
         aux = *N;
         while ( aux -> Proximo  !=  NULL )
                 aux = aux -> Proximo;
         aux -> Proximo = novo;
       }

  return (OK);
}

void exibe_lista (N)
Nodo **N;
{
   Nodo *aux;

   printf ("Lista encadeada:\n");
   aux = *N;
   while ( aux != NULL )
   {
      printf ("Dado: %d\n",aux->Dado);
      aux = aux->Proximo;
   }
   printf ("\n");
}

/**********************
  Fim: rot-listsimp.c
**********************/

