/********************************************************

   ROT-FILA
   ========

   Usa as rotinas basicas de manipulacao de FILAS usando vetores:
   - Estruturas de dados com alocacao estatica
   - Insere no final da fila
   - Remocao do inicio da fila
   - Fila circular

   Aplicacao tipica:
   - Lista de elementos a espera de um tratamento,
     onde a ordem de chegada e importante

   Por: Fernando Osorio
   Data da ultima atualizacao: Out. 2013

*********************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "rot-fila.c"

/***

 => Rotinas de Manipulacao de FILAS - First In, First Out (FIFO)
    Alocacao sequencia

***

void inicializa_fila  (Tipo_Fila *F, int Qtde);
int  insere_fila      (Tipo_Fila *F; Tipo_Dado  Dado);
int  retira_fila      (Tipo_Fila *F; Tipo_Dado *Dado);
void lista_fila       (Tipo_Fila *F);
int  consulta_fila    (Tipo_Fila *F; int Indice; Tipo_Dado *Dado);
int  cheia_fila       (Tipo_Fila *F);
int  vazia_fila       (Tipo_Fila *F);
int  quantidade_fila  (Tipo_Fila *F);
int  acha_fila        (Tipo_Fila *F; Tipo_Dado Dado; int *Indice);

***/

main()
{
  Tipo_Fila Fila;
  int Valor;

  printf("\n>>> ROTINAS DE MANIPULACAO DE FILAS <<<\n\n");

  inicializa_fila(&Fila, 10);

  if (vazia_fila(&Fila))
     printf("=> Fila vazia\n");

  if (insere_fila(&Fila,2))
     printf("=> Valor 2 inserido na fila\n");

  if (insere_fila(&Fila,4))
     printf("=> Valor 4 inserido na fila\n");

  if (insere_fila(&Fila,6))
     printf("=> Valor 6 inserido na fila\n");

  printf("\n=> Elementos da fila... [inicio ao fim]\n");
  lista_fila(&Fila);

  if (acha_fila(&Fila,4,&Valor))
     printf("=> O valor 4 foi achado na posicao %d\n",Valor);

  if (!acha_fila(&Fila,5,&Valor))
     printf("=> O valor 5 nao foi achado na fila\n");

  if (retira_fila(&Fila,&Valor))
     printf("=> Valor %d retirado da fila\n",Valor);

  if (retira_fila(&Fila,&Valor))
     printf("=> Valor %d retirado da fila\n",Valor);

  if (retira_fila(&Fila,&Valor))
     printf("=> Valor %d retirado da fila\n",Valor);

  printf("\n\n");
  
  system("pause");

  printf("\n=> Elementos da fila... [inicio ao fim]\n");
  lista_fila(&Fila);

  if (vazia_fila(&Fila))
     printf("=> Fila vazia\n");
     
  printf("\n\n");

  system("pause");


}

