/********************************************************

   PRG-LISTSIMP
   ============

   Usa Rotinas de manipulacao de LISTAS ENCADEADAS SIMPLES:
   - Estruturas de dados com alocacao dinamica
   - Insere no final da lista, no inicio da lista, ou ordenadamente
   - Remocao do inicio da lista, do final da lista, ou elemento especifico

   Aplicacao tipica:
   - Lista de dinamica de elementos de tamanho variavel

   Por: Fernando Osorio
   Data da ultima atualizacao: Out. 2013

*********************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "listsimp.c"

/***

 => Rotinas de Manipulacao de LISTAS SIMPLES ENCADEADAS
    Alocacao dinamica

***

void inicializa_lista      (Nodo **N);
int insere_inicio_lista    (Nodo **N, Tipo_Dado Dado);
int insere_fim_lista       (Nodo **N, Tipo_Dado Dado);
void exibe_lista           (Nodo **N);

***/


main()
{
  Nodo *Lista;
  int Valor;

  printf("\n>>> ROTINAS DE MANIPULACAO DE LISTAS SIMPLES ENCADEADAS <<<\n\n");

  inicializa_lista(&Lista);

  if (insere_inicio_lista(&Lista,1))
      printf("=> Inserido dado: 1\n");
  else
      printf(">>> Erro de insercao na lista!\n");

  if (insere_inicio_lista(&Lista,2))
      printf("=> Inserido dado: 2\n");
  else
      printf(">>> Erro de insercao na lista!\n");

  if (insere_inicio_lista(&Lista,3))
      printf("=> Inserido dado: 3\n");
  else
      printf(">>> Erro de insercao na lista!\n");

  printf("\n");

  exibe_lista(&Lista);

  printf ("\n\n");
  system("pause");
  
}

