/********************************************************

   PRG-PIL
   =======

   Programa exemplo usando as rotinas basicas de
   manipulacao de Pilha:
   - Estruturas de dados com alocacao estatica
   - Insercao no final (topo) do vetor
   - Remocao  do final (topo) do vetor

   Por: Fernando Osorio
   Data da ultima atualizacao: Out. 2013

*********************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "rot-pil.c"

/***

=> Rotinas de Manipulacao de Pilha - Lista Linear Sequencial
   contidas no arquivo "rot-pil.c"

***

void inicializa_pilha (Tipo_Pilha *P; int Qtde);
int  insere_pilha     (Tipo_Pilha *P; Tipo_Dado Dado);
int  retira_pilha     (Tipo_Pilha *P; Tipo_Dado *Dado);
void exibe_pilha      (Tipo_Pilha *P);
int  quantidade_pilha (Tipo_Pilha *P);
int  cheia_pilha      (Tipo_Pilha *P);
int  vazia_pilha      (Tipo_Pilha *P);
int  esvazia_pilha    (Tipo_Pilha *P);

***/

main()
{
  Tipo_Pilha pilha;
  Tipo_Dado  valor;
  int        qual;

  printf("\n>>> ROTINAS DE MANIPULACAO DE PILHAS - ALOCACAO ESTATICA <<<\n\n");

  inicializa_pilha(&pilha, 10);

  if (vazia_pilha(&pilha))
     printf("=> Pilha vazia...\n");

  if (!insere_pilha(&pilha,2))
     printf(">>> Erro: insere pilha\n");
  else
     printf("=> O valor 2 foi inserido no topo da pilha\n");

  if (!insere_pilha(&pilha,4))
     printf(">>> Erro: insere pilha\n");
  else
     printf("=> O valor 4 foi inserido no topo da pilha\n");

  if (!insere_pilha(&pilha,6))
     printf(">>> Erro: insere pilha\n");
  else
     printf("=> O valor 6 foi inserido no topo da pilha\n");

  printf("=> Elementos da pilha... %d\n",quantidade_pilha(&pilha));
  
  exibe_pilha(&pilha);

  if (retira_pilha(&pilha,&valor))
     printf("=> O valor %d foi excluido do topo da pilha\n",valor);

  if (retira_pilha(&pilha,&valor))
     printf("=> O valor %d foi excluido do topo da pilha\n",valor);

  printf("=> Elementos da pilha... %d\n",quantidade_pilha(&pilha));
  
  exibe_pilha(&pilha);

  printf("\n\n");
  system("pause");
}

