/********************************************************

   PRG-PIL1
   ========

   Programa exemplo usando as rotinas basicas de
   manipulacao de Pilha:
   - Estruturas de dados com alocacao estatica
   - Insercao no final (topo) do vetor
   - Remocao  do final (topo) do vetor

   Inverte o conteudo de uma pilha... usando pilhas!
   
   Por: Fernando Osorio
   Data da ultima atualizacao: Out. 2013

*********************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "rot-pil.c"

/***

=> Rotinas de Manipulacao de Pilha - Lista Linear Sequencial
   contidas no arquivo "rot-pil.c"

***

void inicializa_pilha (Tipo_Pilha *P, int Qtde);
int  insere_pilha     (Tipo_Pilha *P; Tipo_Dado Dado);
int  retira_pilha     (Tipo_Pilha *P; Tipo_Dado *Dado);
void exibe_pilha      (Tipo_Pilha *P);
int  quantidade_pilha (Tipo_Pilha *P);
int  cheia_pilha      (Tipo_Pilha *P);
int  vazia_pilha      (Tipo_Pilha *P);
int  esvazia_pilha    (Tipo_Pilha *P);

***/

main()
{
  Tipo_Pilha p1,p2;
  Tipo_Dado  valor;
  int aux;

  printf("\n>>> ROTINAS DE MANIPULACAO DE PILHAS - ALOCACAO ESTATICA <<<\n\n");

  inicializa_pilha(&p1, 10);
  inicializa_pilha(&p2, 10);

  for (aux=0; aux < 5; aux++)
  {
      printf("Entre com um valor: ");
      scanf ("%d",&valor);
      insere_pilha(&p1,valor);
  }

  printf("\nEstado da pilha (p1): \n");
  exibe_pilha(&p1);
  
  for (aux=0; aux < 5; aux++)
  {
      retira_pilha(&p1,&valor);
      insere_pilha(&p2,valor);
  }

  printf("\nEstado da pilha apos a inversao (p2): \n");
  exibe_pilha(&p2);

  printf("\n\n");
  
  system("pause");
}

