/********************************************************

   ROT-VET
   =======

   Rotinas basicas de manipulacao de Vetores:
   - Estruturas de dados com alocacao estatica
   - Insercao no final do vetor
   - Remocao logica dos elementos

   Aplicacao tipica:
   - Pequenos cadastros

   Por: Fernando Osorio
   Data da ultima atualizacao: Out. 2013

*********************************************************/

/* Incluir stdlib.h e stdio.h */

#define FALSO      0
#define VERDADEIRO 1

#define EXCLUIDO   1

#define OK         1
#define ERRO       0

typedef int Tipo_Dado;

typedef struct
        {
           Tipo_Dado *Dado;
           int       *Excluido;
           int       Tamanho;
           int       Inicio,Fim;
        }  Tipo_Vetor;

/***

=> Rotinas de Manipulacao de Vetores - Lista Linear Sequencial

***/

void inicializa_vetor (Tipo_Vetor *V, int Qtde);
int  insere_vetor     (Tipo_Vetor *V, Tipo_Dado Dado);
int  consulta_vetor   (Tipo_Vetor *V, int Indice, Tipo_Dado *Dado);
int  acha_vetor       (Tipo_Vetor *V, Tipo_Dado Dado, int *Indice);
void lista_vetor      (Tipo_Vetor *V);
int  exclui_vetor     (Tipo_Vetor *V, int Indice);
int  vazio_vetor      (Tipo_Vetor *V);
int  quantidade_vetor (Tipo_Vetor *V);

/***/

void inicializa_vetor (V, Qtde)
Tipo_Vetor *V;
int Qtde;
{
  V->Dado=(Tipo_Dado *)calloc(Qtde,sizeof(Tipo_Dado));
  if (V->Dado == NULL) 
  {
     printf("## Erro de Alocacao ##\n");  /* Aborta programa */
     exit(0);
  }
  V->Excluido=(int *)calloc(Qtde,sizeof(int));
  if (V->Excluido == NULL) 
  {
     printf("## Erro de Alocacao ##\n");  /* Aborta programa */
     exit(0);
  }
  V->Tamanho=Qtde;
  V->Inicio=0;
  V->Fim=0;
}

int insere_vetor (V, Dado)
Tipo_Vetor *V;
Tipo_Dado Dado;
{
  if ((V->Fim) < (V->Tamanho))           /* Vetor nao esta cheio ? */
  {
     V->Dado[V->Fim]=Dado;
     V->Excluido[V->Fim]=FALSO;
     (V->Fim)++;
     return(OK);
  }
  else
     return(ERRO);
}

int consulta_vetor (V, Indice, Dado)
Tipo_Vetor *V;
int Indice;
Tipo_Dado *Dado;
{
  if ((Indice < V->Inicio) || (Indice >= V->Fim) || (V->Excluido[Indice] == EXCLUIDO))
     return(ERRO);
  *Dado=V->Dado[Indice];
  return(OK);
}

int acha_vetor(V, Dado, Indice)
Tipo_Vetor *V;
Tipo_Dado Dado;
int *Indice;
{

  int cont;
  char achou;

  achou=FALSO;
  for (cont=V->Inicio; cont < V->Fim; cont++)
      if ((V->Dado[cont] == Dado) && (V->Excluido[cont] != EXCLUIDO))
      {
         achou=VERDADEIRO;
         *Indice=cont;
         return(OK);
      }
  return(ERRO);
}

void lista_vetor(V)
Tipo_Vetor *V;
{
  Tipo_Dado dado;
  int cont;

  printf("\n");
  for (cont=V->Inicio; cont < V->Fim; cont++)
      if (consulta_vetor(V,cont,&dado))
         printf("Vetor[%d]=%d\n",cont,dado);
      else
         printf("Vetor[%d]= <Excluido>\n",cont);
  printf("\n");
}

int exclui_vetor(V,Indice)
Tipo_Vetor *V;
int Indice;
{
  if ((Indice < V->Inicio) || (Indice >= V->Fim))
     return(ERRO);
  V->Excluido[Indice]=EXCLUIDO;
  return(OK);
}

int vazio_vetor(V)
Tipo_Vetor *V;
{
  if ((V->Fim) == (V->Inicio))
     return(OK);
  else
     return(ERRO);
}

int quantidade_vetor(Tipo_Vetor *V)
{
  return(V->Fim);  /* ou... v.fim-v.inicio */
}

/********************
  Fim das Rotinas
  Rot-Vet.c
********************/

