/********************************************************

   PROG-LISTDUP
   ============

   Usa rotinas de manipulacao de LISTAS ENCADEADAS DUPLAS:
   - Estruturas de dados com alocacao dinamica
   - Insere no inicio ou no final da lista
   - Insere de modo ordenado (antes ou depois de um nodo qualquer)
   - Remove do inicio ou do final da lista

   Aplicacao tipica:
   - Lista de dinamica de elementos de tamanho variavel

   Por: Fernando Osorio
   Data da ultima atualizacao: Out. 2013

*********************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "listdup.c"

/***

 => Rotinas de Manipulacao de LISTAS DUPLAMENTE ENCADEADAS
    Alocacao dinamica

***
     
void inicializa_ld         (Nodo_LD **LD);
void posiciona_inicio_ld   (Nodo_LD **LD);
void posiciona_fim_ld      (Nodo_LD **LD);
int insere_antes_ld        (Nodo_LD **LD, Tipo_Dado Dado);
int insere_depois_ld       (Nodo_LD **LD, Tipo_Dado Dado);
int insere_inicio_ld       (Nodo_LD **LD, Tipo_Dado Dado);
int insere_fim_ld	       (Nodo_LD **LD, Tipo_Dado Dado);
int insere_ordenando_ld    (Nodo_LD **LD, Tipo_Dado Dado);
int pesquisa_ld   	       (Nodo_LD **LD, Tipo_Dado Dado);
int remove_nodo_ld         (Nodo_LD **LD, Tipo_Dado *Dado);
int quantidade_ld          (Nodo_LD **LD);
void exibe_ld              (Nodo_LD **LD);
int percorre_lista         (Nodo_LD **LD, Tipo_Dado *Dado);
void apaga_ld              (Nodo_LD **LD);

***/

/*****

  Programa Principal

*****/

main()
{
  Nodo_LD *ListaDupla;
  Tipo_Dado Dado;
  
  inicializa_ld(&ListaDupla);
  insere_inicio_ld(&ListaDupla,1);
  insere_inicio_ld(&ListaDupla,2);
  insere_inicio_ld(&ListaDupla,3);

  posiciona_inicio_ld(&ListaDupla);
  exibe_ld(&ListaDupla);
  
  posiciona_inicio_ld(&ListaDupla);
  insere_antes_ld(&ListaDupla,-1);
  posiciona_fim_ld(&ListaDupla);
  insere_depois_ld(&ListaDupla,4);
  
  posiciona_inicio_ld(&ListaDupla);
  if (pesquisa_ld(&ListaDupla,2)) 
  {
     printf("Achou valor 2\n");
	 insere_antes_ld(&ListaDupla,10);
	 insere_depois_ld(&ListaDupla,20);
   }
   else
     printf("Nao achou valor 2\n");
  remove_nodo_ld(&ListaDupla,&Dado);
  printf("Dado removido: %d\n",Dado);
  
  posiciona_inicio_ld(&ListaDupla);
  exibe_ld(&ListaDupla);

  printf ("\n\n");
  system("pause");
  
}
