program ordena;

uses crt,graph;

type
   PtrNodoListaDupla = ^NodoListaDupla;
   NodoListaDupla = record
      conteudo : string[77];
      anterior,proximo : PtrNodoListaDupla;
   end;

   vetor = array[1..300] of integer;

procedure InicializaListaDupla(var l:PtrNodoListaDupla);
begin
   l := NIL;
end;

Procedure InsereDepoisListaDupla(var ptr:PtrNodoListaDupla; x:string);
var
   p,aux : PtrNodoListaDupla;
begin
   new(p);
   p^.Conteudo := x;

   if ptr = NIL then
    begin
      p^.Anterior := NIL;
      p^.Proximo := NIL;
    end
   else
    begin
       aux := ptr^.Proximo;
       ptr^.Proximo := p;
       p^.Anterior := ptr;
       p^.Proximo := aux;
       if aux <> NIL then
          aux^.Anterior := p;
    end;
   ptr := p;
end;

Procedure PosicionaInicio(var ptr:PtrNodoListaDupla);
begin
   if ptr <> NIL then
      while ptr^.Anterior <> NIL do
      begin
         ptr := ptr^.Anterior;
      end;
end;

Procedure CarregaArquivo(var l:PtrNodoListaDupla;nomearq:string);
var
   s,slin : string;
   arq : text;
   lin : integer;
begin
   assign(arq,nomearq);
   reset(arq);
   InicializaListaDupla(l);
   lin := 1;
   while NOT eof(arq) do
   begin
      readln(arq,s);
      str(lin:2,slin);
      InsereDepoisListaDupla(l,slin+' '+s);
      inc(lin);
   end;
   PosicionaInicio(l);
   close(arq);
end;

Procedure MostraTexto(arquivo:string);
var
   l,p : PtrNodoListaDupla;
   n : integer;
   ch : char;
begin
   textcolor(BLACK);
   textbackground(WHITE);
   clrscr;
   CarregaArquivo(l,arquivo);
   repeat
      p := l;
      n := 0;
      clrscr;
      while (p <> NIL) AND (n <=23) do
      begin
         textcolor(BLUE);
         write(copy(p^.Conteudo,1,3));
         textcolor(BLACK);
         writeln(copy(p^.Conteudo,4,77));
         p := p^.Proximo;
         inc(n);
      end;
      ch := readkey;

      if ch =#0 then
      begin
         ch := readkey;
         if ch = 'P' then
            if l^.Proximo <> NIL then
               l := l^.Proximo;

         if ch = 'H' then
            if l^.Anterior <> NIL then
               l := l^.Anterior;
      end;
   until ch = #27;
   textcolor(WHITE);
   textbackground(BLACK);
end;

Function MudaDelay(var d:integer): boolean;
var
   ch : char;

begin
   MudaDelay := FALSE;
   if keypressed then
   begin
      ch := readkey;
      if (ch = #27) then
         MudaDelay := TRUE;
      if (ch = '-') and (d < 300) then
         inc(d,10);
      if (ch = '+') and (d > 5) then
         dec(d,5);
      if ch = ' ' then
         readkey;
   end;
end;

procedure DesenhaLinha(v:vetor;i,cor:integer);
begin
   setcolor(cor);
   line(20+i*2,450,20+i*2,450-v[i]);
end;

procedure MisturaVetor(var v:vetor);
var
   i, x, y, aux : integer;

begin
   randomize;
   for i := 1 to 1000 do
   begin
      x := random(300)+1;
      y := random(300)+1;
      DesenhaLinha(v,x,0);
      DesenhaLinha(v,y,0);
      aux := v[x];
      v[x] := v[y];
      v[y] := aux;
      DesenhaLinha(v,x,8);
      DesenhaLinha(v,y,8);
   end;
end;

procedure DesenhaVetor(v:vetor);
var
   i : integer;
begin
   for i := 1 to 300 do
      DesenhaLinha(v,i,8);
end;

procedure BubbleSort1(v:vetor);
var
   i,j,k,aux : integer;
   d : integer;
begin
   d := 20;
   for i := 1 to 300 do
   begin
      for j := i+1 to 300 do
      begin
         DesenhaLinha(v,i,4);
         DesenhaLinha(v,j,4);
         if MudaDelay(d) then
            exit;
         delay(d);
         DesenhaLinha(v,i,8);
         DesenhaLinha(v,j,8);
         if v[i] > v[j] then
         begin
            DesenhaLinha(v,i,0);
            DesenhaLinha(v,j,0);
            aux := v[i];
            v[i] := v[j];
            v[j] := aux;
            DesenhaLinha(v,i,2);
            DesenhaLinha(v,j,2);
         end;
      end;
      DesenhaVetor(v);
   end;
end;

procedure BubbleSort2(v:vetor);
Var
   i, n, troca, aux : integer;
   d : integer;
Begin
   d := 20;
   n := 300;
   repeat
      troca:=0;
      For i:=1 to n-1 do begin
         DesenhaLinha(v,i,4);
         DesenhaLinha(v,i+1,4);
         if MudaDelay(d) then
            exit;
         delay(d);
         DesenhaLinha(v,i,8);
         DesenhaLinha(v,i+1,8);
         If v[i]>v[i+1] then
         begin
            DesenhaLinha(v,i,0);
            DesenhaLinha(v,i+1,0);
            aux:=v[i];
            v[i] := v[i+1];
            v[i+1] := aux;
            DesenhaLinha(v,i,2);
            DesenhaLinha(v,i+1,2);
            troca:=i;
         end;
      end;
      DesenhaVetor(v);
      n :=troca;
   until troca=0;
End;

procedure QuickSort(v:vetor);
var
   d : integer;

Function sort(inicio,fim: integer):boolean;
var
  i,j,x,aux: integer;
  esc : boolean;
begin
  esc := FALSE;
  i:=inicio;
  j:=fim;
  x:=v[(inicio+fim) DIV 2];
  repeat
    while v[i]<x do
       i:=i+1;
    while v[j]>x do
       j:=j-1;

    DesenhaLinha(v,i,4);
    DesenhaLinha(v,j,4);
    esc := MudaDelay(d);
    delay(d);
    DesenhaLinha(v,i,8);
    DesenhaLinha(v,j,8);

    if i<=j then
    begin
      DesenhaLinha(v,i,0);
      DesenhaLinha(v,j,0);

      aux := v[i];
      v[i] := v[j];
      v[j]:=aux;

      DesenhaLinha(v,i,2);
      DesenhaLinha(v,j,2);

      i:=i+1;
      j:=j-1;
    end;
  until (i>j) or esc;
  DesenhaVetor(v);
  if (inicio<j) and (NOT esc) then
     esc := sort(inicio,j);
  if (i<fim) AND (NOT esc) then
     esc := sort(i,fim);
  sort := esc;
end;

begin
  d := 70;
  sort(1,300);
end;

procedure ShellSort(v:vetor);
var
   h: array [1..4] of shortint;
   g,s,z,e,i,j: integer;
   d : integer;
begin
   h[1]:=9;
   h[2]:=5;
   h[3]:=3;
   h[4]:=1;
   d := 20;
   for s:=1 to 4 do
   begin
      z:= h[s];
      for e:=1 to z do
      begin
         i:= e+z;
         while i <= 300 do
         begin
            g:= v[i];
            j:= i-z;

            DesenhaLinha(v,i,4);
            DesenhaLinha(v,j,4);
            if MudaDelay(d) then
               exit;
            delay(d);
            DesenhaLinha(v,i,8);
            DesenhaLinha(v,j,8);

            while ( g < v[j] ) and (j > z-e) do
            begin
               if MudaDelay(d) then
                  exit;
               delay(d);

               DesenhaLinha(v,j+z,0);
               v[j+z]:=v[j];
               DesenhaLinha(v,j+z,4);
               delay(d);
               DesenhaLinha(v,j+z,2);
               j:=j-z;
            end;
            DesenhaLinha(v,j+z,0);
            v[j+z]:=g;
            DesenhaLinha(v,j+z,2);
            i:=i+z;
         end;
         DesenhaVetor(v);
      end;
   end;
end;

procedure MergeSort(var v:vetor);
var
   v2 : Vetor;

Function Ordena(l,r:integer):boolean;
var
   meio,i1,i2,ia : integer;
   d : integer;
   esc : boolean;

begin
   d := 10;
   esc := FALSE;
   if (l<r) and (NOT esc) then
   begin
      meio := (l+r) div 2;
      esc := Ordena(l,meio);
      if NOT esc then
      begin
         esc := Ordena(meio+1,r);

         i1 := l;
         i2 := meio+1;
         ia := l;
         while (i1<=meio) AND (i2 <=r) do
         begin
            if v[i1] < v[i2] then
             begin
               v2[ia] := v[i1];
               i1:=i1+1;
             end
            else
             begin
               v2[ia] := v[i2];
               i2:=i2+1;
             end;
            inc(ia);
         end;
         if i1 > meio then
            while i2 <=r do
            begin
               v2[ia] := v[i2];
               inc(i2);
               inc(ia);
            end
         else
            while i1 <= meio do
            begin
               v2[ia] := v[i1];
               inc(i1);
               inc(ia);
            end;
         for ia := l to r do
         begin
            DesenhaLinha(v,l,4);
            DesenhaLinha(v,r,4);
            if NOT esc then
               esc := MudaDelay(d);
            delay(d);
            DesenhaLinha(v,l,8);
            DesenhaLinha(v,r,8);

            if v[ia] <> v2[ia] then
            begin
               DesenhaLinha(v,ia,0);
               v[ia] := v2[ia];
               DesenhaLinha(v,ia,2);
            end;
         end;
         DesenhaVetor(v);
      end;
   end;
   Ordena := esc;
end;

begin
   Ordena(1,300);
end;

procedure InsertionSort(v:vetor);
var
   i,j,x : integer;
   d : integer;
begin
   d := 20;
   for i := 2 to 300 do
   begin
      DesenhaLinha(v,i,4);
      x := v[i];
      j := i;
      while (x < v[j-1]) AND (j > 1)do
      begin
         DesenhaLinha(v,j,4);
         if MudaDelay(d) then
            exit;
         delay(d);
         DesenhaLinha(v,j,0);
         v[j] := v[j-1];
         DesenhaLinha(v,j,2);
         dec(j);
      end;
      DesenhaLinha(v,j,0);
      v[j] := x;
      DesenhaLinha(v,j,2);
      DesenhaVetor(v);
   end;
end;

procedure ShakerSort(v:vetor);
var
   d,l,r,k,j,x : integer;
begin
   d := 20;
   l := 2;
   r := 300;
   k := 300;
   repeat
      DesenhaLinha(v,l,4);
      DesenhaLinha(v,r,4);
      for j := r downto l do
      begin
         if MudaDelay(d) then
            exit;
         delay(d);
         if v[j-1] > v[j] then
         begin
           DesenhaLinha(v,j,0);
           DesenhaLinha(v,j-1,0);
           x := v[j-1];
           v[j-1] := v[j];
           v[j] := x;
           DesenhaLinha(v,j,2);
           DesenhaLinha(v,j-1,2);
           k := j;
         end
      end;
      DesenhaVetor(v);
      DesenhaLinha(v,l,4);
      DesenhaLinha(v,r,4);
      l := k+1;
      for j := l to r do
      begin
         if MudaDelay(d) then
            exit;
         delay(d);
         if v[j-1] > v[j] then
         begin
           DesenhaLinha(v,j,0);
           DesenhaLinha(v,j-1,0);
           x := v[j-1];
           v[j-1] := v[j];
           v[j] := x;
           DesenhaLinha(v,j,2);
           DesenhaLinha(v,j-1,2);
           k := j;
         end
      end;
      r := k-1;
      DesenhaVetor(v);
   until l > r;
end;

Procedure SelectionSort(v:vetor);
var
   i,j,k,x : integer;
   d : integer;
begin
   d := 10;
   for i := 1 to 299 do
   begin
      k := i;
      x := v[i];
      DesenhaLinha(v,i,4);
      for j := i+1 to 300 do
      begin
         DesenhaLinha(v,j,4);
         if MudaDelay(d) then
            exit;
         delay(d);
         DesenhaLinha(v,j,8);
         if v[j] < x then
         begin
            DesenhaLinha(v,j,2);
            k := j;
            x := v[k];
         end;
      end;
      DesenhaLinha(v,k,0);
      DesenhaLinha(v,i,0);
      v[k] := v[i];
      v[i] := x;
      DesenhaLinha(v,k,2);
      DesenhaLinha(v,i,2);
      DesenhaVetor(v);
   end;
end;

type
   Heap = record
      vet : vetor;
      tam : integer;
   end;

Function Pai(i:integer):integer;
begin
   Pai := i div 2;
end;

Function FilhoEsq(i:integer):integer;
begin
   FilhoEsq := 2*i;
end;

Function FilhoDir(i:integer):integer;
begin
   FilhoDir := 2*i+1;
end;

Procedure HeapSort(v:vetor);
var
   d : integer;

Function TransformaHeap(var h:Heap;pos:integer):boolean;
var
   esq,dir,maior,aux : integer;
   esc : boolean;
begin
   esq := FilhoEsq(pos);
   dir := FilhoDir(pos);

   if (esq <= h.tam) AND (h.vet[esq] > h.vet[pos]) then
      maior := esq
   else
      maior := pos;
   if (dir <= h.tam) AND (h.vet[dir] > h.vet[maior]) then
      maior := dir;
   esc := MudaDelay(d);
   delay(d);
   if (maior <> pos) AND (NOT esc) then
   begin
      DesenhaLinha(h.vet,pos,0);
      DesenhaLinha(h.vet,maior,0);
      aux := h.vet[pos];
      h.vet[pos] := h.vet[maior];
      h.vet[maior] := aux;
      DesenhaLinha(h.vet,pos,2);
      DesenhaLinha(h.vet,maior,2);
      esc := TransformaHeap(h,maior);
   end;
   TransformaHeap := esc;
end;

Procedure CriaHeap(var h:Heap);
var
   i : integer;
begin
   for i := h.tam div 2 downto 1 do
      TransformaHeap(h,i);
end;

var
   h : Heap;
   i, aux : integer;
begin
   d := 10;
   h.tam := 300;
   for i := 1 to 300 do
      h.vet[i] := v[i];
   CriaHeap(h);
   readkey;
   DesenhaVetor(h.vet);
   d := 120;
   for i := h.Tam downto 2 do
   begin
      DesenhaLinha(h.vet,1,0);
      DesenhaLinha(h.vet,i,0);
      aux := h.vet[1];
      h.vet[1] := h.vet[h.tam];
      h.vet[h.tam] := aux;
      DesenhaLinha(h.vet,1,2);
      DesenhaLinha(h.vet,i,2);
      DesenhaLinha(h.vet,i,4);
      dec(h.tam);
      if TransformaHeap(h,1) then
         break;
      DesenhaVetor(h.vet);
   end;
end;

var
   gd,gm,i : integer;
   v : vetor;
   op : char;

begin
 while true do
 begin
   clrscr;

   writeln('A/1 - Bubblesort (Versao 1)');
   writeln('B/2 - Bubblesort (Versao 2)');
   writeln('C/3 - Shakersort');
   writeln('D/4 - Insertion sort');
   writeln('E/5 - Select sort');
   writeln('F/6 - Shellsort');
   writeln('G/7 - Merge Sort');
   writeln('H/8 - Heapsort');
   writeln('I/9 - Quicksort');
   writeln('0 - Sair');
   repeat
      readln(op);
      op := upcase(op);
   until (op >= '0') AND (op <= '9') OR (op >= 'A') AND (op <= 'I');
   if op = '0' then
   begin
      clrscr;
      exit;
   end;

   if op < 'A' then
   begin
      gd := DETECT;
      initgraph(gd,gm,'');

      for i := 1 to 300 do
         v[i] := i;
      DesenhaVetor(v);
      readkey;
      MisturaVetor(v);
      readkey;
   end;

   case op of
      '1' : BubbleSort1(v);
      '2' : BubbleSort2(v);
      '3' : ShakerSort(v);
      '4' : InsertionSort(v);
      '5' : SelectionSort(v);
      '6' : ShellSort(v);
      '7' : MergeSort(v);
      '8' : HeapSort(v);
      '9' : QuickSort(v);
      'A' : MostraTexto('bubble1.txt');
      'B' : MostraTexto('bubble2.txt');
      'C' : MostraTexto('shaker.txt');
      'D' : MostraTexto('insert.txt');
      'E' : MostraTexto('select.txt');
      'F' : MostraTexto('shell.txt');
      'G' : MostraTexto('merge.txt');
      'H' : MostraTexto('heap.txt');
      'I' : MostraTexto('qsort.txt');
   end;

   if op < 'A' then
      readkey;
   closegraph;
 end;
end.