/*
   Programa: Labirinto  [Recursivo]
*/

#include <stdio.h>
#include <stdlib.h>

#define MAXCOL 10
#define MAXLIN 10

#define FALSE   0
#define TRUE    1

#define LIVRE            0
#define OCUPADO          1
#define VISITADO        -1
#define CAMINHO_SAIDA   -2
#define SAIDA_LABIRINTO 100


int Matriz[MAXLIN][MAXCOL];

int procura(M,lin,col)
int M[MAXLIN][MAXCOL];
int lin,col;
{
  char proc;

  if ( (lin > MAXLIN) || (lin < 0) || (col > MAXCOL) || (col < 0) )
     proc=FALSE;
  else
     if ( (M[lin][col] == OCUPADO) || (M[lin][col] == VISITADO) )
        proc=FALSE;
     else if (M[lin][col] == SAIDA_LABIRINTO)
             proc=TRUE;
          else if (M[lin][col] == LIVRE)
               {
                   M[lin][col]=VISITADO;        /* Marca que ja passou aqui */
                   proc = procura(M,lin-1,col);
                   proc = procura(M,lin,col-1) || proc;
                   proc = procura(M,lin,col+1) || proc;
                   proc = procura(M,lin+1,col) || proc;
               }

   if (proc==TRUE)
   {
     printf("%d,%d # ",lin,col);
     M[lin][col]=CAMINHO_SAIDA;
   }
   return(proc);
}

void le_arquivo(nome,M)
char nome[255];
int  M[MAXLIN][MAXCOL];
{
  FILE *arqtxt;
  int lin,col;

  arqtxt=fopen(nome,"rt");
  if (arqtxt==NULL)
  {
     printf("=> ERRO: Falha na abertura do arquivo\n\n");
     exit(-1);
  }

  for (lin=0; lin < MAXLIN; lin++)
      for (col=0; col < MAXCOL; col++)
          fscanf(arqtxt,"%d\n",&(M[lin][col]));

  fclose(arqtxt);
}

void mostra_matriz(M)
int M[MAXLIN][MAXCOL];
{
  int lin,col;

  for (lin=0; lin < MAXLIN; lin++)
  {
      for (col=0; col < MAXCOL; col++)
      {
          if (M[lin][col] == LIVRE)
             printf(" ");
          if (M[lin][col] == OCUPADO)
             printf("O");
          if (M[lin][col] == VISITADO)
             printf(".");
          if (M[lin][col] == CAMINHO_SAIDA)
             printf("+");
          if (M[lin][col] == SAIDA_LABIRINTO)
             printf("$");
      }
      printf("\n");
  }
}

main()
{
  int Labirinto[MAXLIN][MAXCOL];

  printf("\n\n>>> LABIRINTO / RECURSIVIDADE <<<\n\n");
  le_arquivo("labirinto.txt",Labirinto);
  mostra_matriz(Labirinto);
  printf("\n>> Pressione uma tecla para continuar...\n");
  getch();

  printf("\nCaminho a percorrer para chegar na saida (linha,coluna): \n");
  if (procura(Labirinto,0,0)==TRUE)
     printf("\n>> ACHOU! <<\n");
  else
     printf("\n>> NAO ACHOU! <<\n");

  printf("\n");
  mostra_matriz(Labirinto);
  printf("\n\n");

  system("Pause");

}
