/********************************************************

   PROG-ARVBIN
   ===========

   Usa rotinas de manipulacao de ARVORES BINARIAS:
   - Estruturas de dados com alocacao dinamica
   - Insere ordenado
   - Insere a esquerda ou a direita
   - Exibe arvore em modo pre-fixado, infixado e pos-fixado
   - Remocao (nao implementada): sugere-se remocao logica

   Aplicacao tipica:
   - Busca binaria em arvores ordenadas

   Por: Fernando Osorio
   Data da ultima atualizacao: Nov. 2013

*********************************************************/


#include <stdio.h>
#include <stdlib.h>

#include "arvexpr.c"

/***

 => Rotinas de Manipulacao de ARVORES BINARIAS
    Alocacao dinamica

/***  Rotinas...

void inicializa_arvbin  (Nodo_AB **AB);
int  insere_raiz_arvbin (Nodo_AB **AB, Tipo_Dado Dado);
int  insere_ord_arvbin  (Nodo_AB **AB, Tipo_Dado Dado);
int  insere_esq_arvbin  (Nodo_AB **AB, Tipo_Dado Dado);             
int  insere_dir_arvbin  (Nodo_AB **AB, Tipo_Dado Dado);

void exibe_ab_infixado  (Nodo_AB *AB);
void exibe_ab_prefixado (Nodo_AB *AB);
void exibe_ab_posfixado (Nodo_AB *AB);

int  pesquisa_arvbin    (Nodo_AB *AB, Nodo_AB **Nodo, Tipo_Dado Dado);

void apaga_arvbin       (Nodo_AB **AB);
int  remove_dado_arvbin (Nodo_AB **AB, Tipo_Dado Dado);
int  conta_nodos_arvbin (Nodo_AB **AB);
int  maior_arvbin       (Nodo_AB **AB, Tipo_Dado *Dado);
int  menor_arvbin       (Nodo_AB **AB, Tipo_Dado *Dado);
int  sucessor_arvbin    (Nodo_AB **AB, Tipo_Dado *Dado);
int  predecessor_arvbin (Nodo_AB **AB, Tipo_Dado *Dado);

***/

/*****

  Programa Principal

*****/


main ( )
{

  Nodo_AB *Arvore;
  Nodo_AB *Nodo;
  Tipo_Dado Dado;

  inicializa_arvbin (&Arvore);

  strcpy(Dado.nome,"OP1");
  Dado.op='*';
  Dado.tipo=0;
  Dado.num=0;
  
  if ( insere_raiz_arvbin (&Arvore, Dado) )
     printf("Raiz inserida\n");
  else
     printf("Erro na insercao da raiz\n");
  
  strcpy(Dado.nome,"NRO");
  Dado.op='#';
  Dado.tipo=1;
  Dado.num=3.0;
  
  if ( insere_esq_arvbin (&Arvore, Dado) )
     printf("Dado esquerda inserido\n");
  else
     printf("Erro na insercao dado esquerda (%f)\n",Dado.num);

  strcpy(Dado.nome,"OP1");
  if (pesquisa_arvbin( Arvore, &Nodo, Dado ) == ACHOU )
     printf("Achou! Op: %c\n",Nodo->Dado.op);
  else 
     printf("Nao achou!\n");
  
  strcpy(Dado.nome,"OP2");
  Dado.op='+';
  Dado.tipo=0;
  Dado.num=0;
  
  if ( insere_dir_arvbin (&Nodo, Dado) )
     printf("Operador direita inserido\n");
  else
     printf("Erro na insercao operador direita (%c)\n",Dado.op);
     
  strcpy(Dado.nome,"OP2");
  if (pesquisa_arvbin( Arvore, &Nodo, Dado ) == ACHOU )
     printf("Achou! Op: %c\n",Nodo->Dado.op);
  else 
     printf("Nao achou!\n");
  
  strcpy(Dado.nome,"NRO");
  Dado.op='#';
  Dado.tipo=1;
  Dado.num=5.0;
  
  if ( insere_esq_arvbin (&Nodo, Dado) )
      printf("Operador direita inserido\n");
  else
      printf("Erro na insercao operador direita (%c)\n",Dado.op);
     
    strcpy(Dado.nome,"NRO");
  Dado.op='#';
  Dado.tipo=1;
  Dado.num=4.0;
  
  if ( insere_dir_arvbin (&Nodo, Dado) )
      printf("Operador direita inserido\n");
  else
      printf("Erro na insercao operador direita (%c)\n",Dado.op);
    

  //printf("\nArvore: modo infixado\n");
  //exibe_ab_infixado(Arvore);
//
  //printf("\nArvore: modo prefixado\n");
  //exibe_ab_prefixado(Arvore);
//
  printf("\nArvore: modo posfixado\n");
  exibe_ab_posfixado(Arvore);

/* 
  printf("\nPesquisa valor 7: ");
  Nodo = NULL;
  if (pesquisa_arvbin( Arvore, &Nodo, 7 ) == ACHOU)
     printf("Achou! (%d)\n", Nodo->Dado);
  else 
     printf("Nao achou!\n");
	 
  printf("\nPesquisa valor 15: ");
  Nodo = NULL;
  if (pesquisa_arvbin( Arvore, &Nodo, 15 ) == ACHOU)
     printf("Achou! (%d)\n", Nodo->Dado);
  else 
     printf("Nao achou!\n");
  
  if ( insere_esq_arvbin(&Nodo, 12) )
     printf("\nInsercao do valor: 12\n");
  else
     printf(">> Erro na insercao!\n");
	 
  printf("\nArvore: modo infixado\n");
  exibe_ab_infixado(Arvore);
  
  if ( insere_dir_arvbin(&Nodo, 17) )
     printf("\nInsercao do valor: 17\n");
  else
     printf(">> Erro na insercao!\n");
	 
  printf("\nArvore: modo infixado\n");
  exibe_ab_infixado(Arvore);
  
  printf("\nFim\n");
*/
  printf ("\n\n");
  system("Pause");
  
}
