// Copyright 2006-2015 Coppelia Robotics GmbH. All rights reserved. 
// marc@coppeliarobotics.com
// www.coppeliarobotics.com
// 
// -------------------------------------------------------------------
// THIS FILE IS DISTRIBUTED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED
// WARRANTY. THE USER WILL USE IT AT HIS/HER OWN RISK. THE ORIGINAL
// AUTHORS AND COPPELIA ROBOTICS GMBH WILL NOT BE LIABLE FOR DATA LOSS,
// DAMAGES, LOSS OF PROFITS OR ANY OTHER KIND OF LOSS WHILE USING OR
// MISUSING THIS SOFTWARE.
// 
// You are free to use/modify/distribute this file for whatever purpose!
// -------------------------------------------------------------------
//

#ifdef _CH_
#pragma package <opencv>
#endif

#define CV_NO_BACKWARD_COMPATIBILITY

#ifndef _EiC
#include "cv.h"
#include "highgui.h"
#include <stdlib.h>
#include <stdio.h>
#endif

#include <string.h>
#include <math.h>

// This file was automatically created for V-REP release V3.2.1 on May 3rd 2015

#include <stdio.h>
#include "simpleInConnection.h"
#include <cstdlib>
#define pi 3.141593f

#define MAX_X 500
#define MAX_Y 500

char wndname[30] = "Drawing Demo";
int WWidth = MAX_X, WHeight = MAX_Y;  // 800 x 800 pixels 
int line_type = CV_AA; // change it to 8 to see non-antialiased graphics
CvPoint pt1,pt2;
IplImage* image;

FILE *datalog;

int main(int argc, char* argv[])
{ // We connect to the port number passed as argument
	int portNb=0;
	if (argv[1]!=NULL)
		portNb=atoi(argv[1]);
	if (portNb==0)
	{
		printf("Indicate the connection port number as argument!\n");
		#ifdef _WIN32
			Sleep(5000);
		#else
			usleep(5000*1000);
		#endif
		return 0;
	}

        image = cvCreateImage( cvSize(WWidth,WHeight), 8, 3 );
        cvNamedWindow(wndname, 1 );
        cvZero( image );
  	pt1.x=MAX_X/2;
  	pt1.y=MAX_Y/2;
  	cvCircle( image, pt1, 50, CV_RGB(255,255,255), 3, line_type, 0 );
  	cvShowImage(wndname,image);
  	cvWaitKey(1000);
	cvZero( image );
  	pt1.x=0; pt1.y=0; pt2.x=MAX_X-1; pt2.y=MAX_Y-1;
  	cvRectangle( image,pt1, pt2, CV_RGB(255,255,255), 3, line_type, 0 );
  	cvShowImage(wndname,image);
  	cvWaitKey(1000);

	CSimpleInConnection connection(portNb);
	printf("Connecting to client...\n");
	if (connection.connectToClient())
	{
		printf("Connected with client.\n");
		float motorSpeeds[2];
		while (true)
		{ // This is the server loop (the robot's control loop):
			int receivedDataLength;
                        int i;
                        float angulo;
			char* receivedData=connection.receiveData(receivedDataLength);
			// printf("Lenght: %d - %f\n",receivedDataLength,((float*)receivedData)[180]);


			if (receivedData!=NULL)
			{ // We received data. The server ALWAYS replies!
				// We received 2 floats (the sensorDistance and the simulation time):
				// float sensorReading=((float*)receivedData)[0];
				// float simulationTime=((float*)receivedData)[1];

				// Prepare to plot data
				// datalog=fopen("datalog.txt","at");			
			  	cvZero( image );
				for (i=0; i < 360; i++)
				{
				    pt1.x=250;
				    pt1.y=250;
				    angulo=(i/2.0*M_PI)/180.0;

 				    pt2.x=250+(int)(((float*)receivedData)[i]*50*cos(angulo));
				    pt2.y=250-(int)(((float*)receivedData)[i]*50*sin(angulo));

				    cvLine( image, pt1, pt2, CV_RGB(255,255,255), 3, line_type, 0 );
                                    //fprintf(datalog,"%.4lf\t",((float*)receivedData)[i]);
				}
				//fprintf(datalog,"\n");
				//fclose(datalog);
				cvShowImage(wndname,image);
				cvWaitKey(100);

				delete[] receivedData;

				// No more motoSpeeds (Keyboard controlled)
				motorSpeeds[0]=0.0;
				motorSpeeds[1]=0.0;

				// We reply with 2 floats (the left and right motor speed in rad/sec)
				if (!connection.replyToReceivedData((char*)motorSpeeds,sizeof(float)*2))
				{
					printf("Failed to send reply.\n");
					break;
				}
			}
			else
				break; // error
		}
	}
	else
		printf("Failed to connect to client.\n");
	#ifdef _WIN32
		Sleep(5000);
	#else
		usleep(5000*1000);
	#endif
	return 0;
}

